/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */

#include <addincomm.h>
#include <osutils.h> /* For sysbeep() */
#include <stdio.h>   /* For debug printf's. */

/****************************************************************/
/*                                                              */
/* Test Channel Handler                                         */
/*                                                              */
/****************************************************************/

test_server (cmd) 
	acb *cmd;
{
  unsigned char op;
		
  cmd = (acb *)(ptr32to24(cmd));
  op = opcode(cmd);
		
  printf("Cmd= %x, Op= %d.\n", cmd, op);
		
  switch(op & 0x7f)
	{
	case 0x00: unhandled_cmd(); break;            /*   0 */
	case 0x01: test_get_acb(cmd);      break;     /*   1 */
	case 0x02: test_return_acb(cmd);   break;     /*   2 */
	case 0x03: test_q_lock(cmd);       break;     /*   3 */
	case 0x04: test_q_unlock(cmd);     break;     /*   4 */
	case 0x05: unhandled_cmd(); break;            /*   5 */
	case 0x06: unhandled_cmd(); break;            /*   6 */
	case 0x07: unhandled_cmd(); break;            /*   7 */
	case 0x08: unhandled_cmd(); break;            /*   8 */
	case 0x09: unhandled_cmd(); break;            /*   9 */
	case 0x0A: unhandled_cmd(); break;            /*  10 */
	case 0x7f: break;							/* x7F NOP */	
	default:   unhandled_cmd; break;
	}
  
  set_servicer_status(cmd, 0xc0);		/* Set servicer complete and input complete. */
  
}


test_driver (cmd)
	 acb *cmd;
{
  printf("Cmd= %x\n", cmd);
}


/****************************************************************/
/*                                                              */
/* Test Routines                                                */
/*                                                              */
/****************************************************************/

test_get_acb (cmd)
	acb *cmd;
{
  int size;
  acb *ptr;
  
  size = parm_16b(cmd,0);
  printf("size= %d\n",size);

  ptr = get_acb_fast(size);
  printf("acb= %x\n",ptr);

  ptr = (acb *) lispm_q_elem((q_elem *)ptr);   /* clm 9/27/89 - cast to (acb *) */
  printf("lispm acb= %x\n",ptr);

  set_parm_32b(cmd,1,ptr);
}


test_return_acb (cmd)
	acb *cmd;
{
  int size;
  queue_struct *q;
  Ptr lispm_acb;
  acb *mac_acb;

  lispm_acb = (Ptr)parm_32b(cmd, 0);    /* clm 9/27/89 - changed cast from (acb *) to (Ptr) to match lispm_acb declaration */
  printf("lispm acb=%x\n", lispm_acb);

  mac_acb = (acb *) mac_q_elem((q_elem *)lispm_acb);  /* clm 9/27/89 - cast to (acb *)  */
  printf("mac acb=%x\n", mac_acb);
  
  size = data_bytes(mac_acb);
  printf("size= %d\n",size);

  q = find_q(size);
  printf("queue= %x\n", q);
 
  return_acb_fast(mac_acb);

}

test_q_lock (cmd)
	acb *cmd;
{
  int size;
  queue_struct *q;

  size = parm_32b(cmd, 0);
  printf("size= %d\n",size);

  q = find_q(size);
  printf("queue= %x\n", q);

  printf("q struct size = %d.\n", sizeof(q));
  
  printf("lock byte = %x\n", &(q->lock));
  if (q) get_q_lock(q);
 
}

test_q_unlock (cmd)
	acb *cmd;
{
  int size;
  queue_struct *q;

  size = parm_32b(cmd, 0);
  printf("size= %d\n",size);

  q = find_q(size);
  printf("queue= %x\n", q);

  if (q) q_unlock(q);
 
}